;
; ------------------------------------------------------------
;
;   PureBasic - Shaders - Cellshading
;
;    (c) 2010 - djes
;
; ------------------------------------------------------------
;

IncludeFile "Screen3DRequester.pb"

Define.f KeyX, KeyY, MouseX, MouseY

If InitEngine3D()

  Add3DArchive("data\", #PB_3DArchive_FileSystem  )
  
  InitSprite()
  InitKeyboard()
  InitMouse()

  If Screen3DRequester()
    
    refresh_rate.l  =  60

    ;SetRefreshRate(refresh_rate)
    SetFrameRate(refresh_rate)

    Parse3DScripts()

    LoadMesh   (1 , "Ogre.mesh")

    CreateEntity(1,   MeshID(1),  #PB_Material_None)

    ;AmbientColor(RGB(255, 255, 255))  
    
    CreateLight(0, RGB(255, 0, 255))
    LightLocate(0, -50000, 50000, 50000)

    CreateLight(1, RGB(0, 255, 255))
    LightLocate(1, 50000, -50000, 50000)

     ;--- Camera

    ;Little computation to convert our pixels window to the % ogre
    level_min_x  = 0
    level_min_y  = 0
    level_max_x  = 1024
    level_max_y  = 768
    level_width  = level_max_x - level_min_x
    level_height = level_max_y - level_min_y
    CreateCamera(0, (level_min_x * 100) / ScreenWidth, (level_min_y * 100) / ScreenHeight, (level_width * 100) / ScreenWidth, (level_width * 100) / ScreenWidth)

    cam_x.f = 0
    cam_y.f = 0
    cam_z.f = 4000
    CameraLocate(0, cam_x, cam_y, cam_z)
                                             
    Repeat

      Screen3DEvents()
      
      ClearScreen(RGB(50, 0, 0))
                 
      i.f+0.009
      
      CameraLocate(0, (1 + Sin(i / 2)) * 5000 * Sin(i * 0.4), 5000 * Sin(i), (1 + Sin(i / 2)) * 5000 * Cos(i * 0.4))
      CameraLookAt(0, 0 , 0, 0)
    
      RenderWorld()
      Screen3DStats()
      FlipBuffers()

    Until KeyboardPushed(#PB_Key_Escape) Or Quit = 1
  EndIf
    
Else
  MessageRequester("Error", "The 3D Engine can't be initialized",0)
EndIf
  
End
; IDE Options = PureBasic 4.40 (Windows - x86)
; CursorPosition = 6
; Executable = C:\0\fire.exe
; SubSystem = OpenGL